//
//  YHFamilyMemberRiskWarningAlertView.swift
//  galaxy
//
//  Created by edy on 2024/8/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHFamilyMemberRiskWarningAlertView: UIView {

    var confirmBlock:(()->())?
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var iconImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "cs_family_risk"))
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "风险预警"
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14.0)
        let a: ASAttributedString = .init("如若在", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let b: ASAttributedString = .init("等待获批期间", .font(UIFont.PFSC_B(ofSize: 14)),.foreground(UIColor.brandMainColor))
        let c: ASAttributedString = .init("，您的家庭信息与之前递交港府的", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let d: ASAttributedString = .init("申请资料不一致，请务必如实告知", .font(UIFont.PFSC_B(ofSize: 14)),.foreground(UIColor.brandMainColor))
        let e: ASAttributedString = .init("，因为这会导致后续赴港激活签证所带的证件不一样！", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        label.attributed.text = a+b+c+d+e
        return label
    }()
    
    lazy var confirmBtn: UIButton = {
        let button = UIButton()
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        button.setTitle("我已知悉，确认", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.backgroundColor = .brandMainColor
        button.addTarget(self, action: #selector(didConfirmBtnClicked), for: .touchUpInside)
        button.layer.cornerRadius = kCornerRadius3
        return button
    }()
    
    static func alertView() -> YHFamilyMemberRiskWarningAlertView {
        let view = YHFamilyMemberRiskWarningAlertView(frame: UIScreen.main.bounds)
        return view
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    @objc func didConfirmBtnClicked() {
        confirmBlock?()
        self.dismiss()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(iconImgView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(detailLabel)
        whiteContentView.addSubview(confirmBtn)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerY.equalToSuperview()
        }
        
        iconImgView.snp.makeConstraints { make in
            make.width.height.equalTo(53)
            make.top.equalTo(30)
            make.centerX.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(iconImgView.snp.bottom).offset(16)
            make.height.equalTo(24)
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
        }
        
        confirmBtn.snp.makeConstraints { make in
            make.top.equalTo(detailLabel.snp.bottom).offset(30)
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.bottom.equalTo(-21)
            make.height.equalTo(45)
        }
    }
}
